/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.fabric.platform.fluid;

import java.util.Optional;
import mod.chiselsandbits.platforms.core.dist.DistExecutor;
import mod.chiselsandbits.platforms.core.fluid.FluidInformation;
import mod.chiselsandbits.platforms.core.fluid.IFluidManager;
import net.fabricmc.fabric.api.transfer.v1.client.fluid.FluidVariantRendering;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3611;
import net.minecraft.class_3612;

public class FabricFluidManager
implements IFluidManager {
    private static final FabricFluidManager INSTANCE = new FabricFluidManager();

    public static FabricFluidManager getInstance() {
        return INSTANCE;
    }

    private FabricFluidManager() {
    }

    @Override
    public Optional<FluidInformation> get(class_1799 stack) {
        try (Transaction context = Transaction.openOuter();){
            Storage target = (Storage)FluidStorage.ITEM.find(stack, (Object)ContainerItemContext.withInitial((class_1799)stack));
            if (target == null) {
                Optional<FluidInformation> optional = Optional.empty();
                return optional;
            }
            Iterable fluids = target.iterable((TransactionContext)context);
            if (!fluids.iterator().hasNext()) {
                Optional<FluidInformation> optional = Optional.empty();
                return optional;
            }
            StorageView view = (StorageView)fluids.iterator().next();
            Optional<FluidInformation> optional = Optional.of(new FluidInformation(((FluidVariant)view.getResource()).getFluid(), view.getAmount(), ((FluidVariant)view.getResource()).copyNbt()));
            return optional;
        }
    }

    @Override
    public class_1799 extractFrom(class_1799 stack, long amount) {
        try (Transaction context = Transaction.openOuter();){
            Optional<FluidInformation> contained = this.get(stack);
            class_1799 class_17992 = contained.map(fluid -> {
                FluidVariant variant = FabricFluidManager.makeVariant(fluid);
                ContainerItemContext containerContext = ContainerItemContext.withInitial((class_1799)stack);
                ((Storage)FluidStorage.ITEM.find(stack, (Object)containerContext)).extract((Object)variant, amount, (TransactionContext)context);
                StorageView itemVariant = (StorageView)containerContext.getMainSlot().iterator((TransactionContext)context).next();
                return ((ItemVariant)itemVariant.getResource()).toStack((int)itemVariant.getAmount());
            }).orElse(class_1799.field_8037);
            return class_17992;
        }
    }

    @Override
    public class_1799 insertInto(class_1799 stack, FluidInformation fluidInformation) {
        try (Transaction context = Transaction.openOuter();){
            Optional<FluidInformation> contained = this.get(stack);
            class_1799 class_17992 = contained.map(fluid -> {
                FluidVariant variant = FabricFluidManager.makeVariant(fluid);
                ContainerItemContext containerContext = ContainerItemContext.withInitial((class_1799)stack);
                ((Storage)FluidStorage.ITEM.find(stack, (Object)containerContext)).insert((Object)variant, fluidInformation.amount(), (TransactionContext)context);
                StorageView itemVariant = (StorageView)containerContext.getMainSlot().iterator((TransactionContext)context).next();
                return ((ItemVariant)itemVariant.getResource()).toStack((int)itemVariant.getAmount());
            }).orElse(class_1799.field_8037);
            return class_17992;
        }
    }

    @Override
    public int getFluidColor(FluidInformation fluid) {
        return (Integer)DistExecutor.unsafeRunForDist(() -> () -> FluidVariantRendering.getColor((FluidVariant)FabricFluidManager.makeVariant(fluid)), () -> () -> 0xFFFFFF);
    }

    @Override
    public class_2561 getDisplayName(class_3611 fluid) {
        return (class_2561)DistExecutor.unsafeRunForDist(() -> () -> FluidVariantRendering.getName((FluidVariant)FabricFluidManager.makeVariant(new FluidInformation(fluid))), () -> () -> fluid.method_15785().method_15759().method_26204().method_9518());
    }

    public static FluidVariant makeVariant(FluidInformation fluid) {
        if (!fluid.fluid().method_15793(fluid.fluid().method_15785()) && fluid.fluid() != class_3612.field_15906) {
            return FabricFluidManager.makeVariant(fluid.withSource());
        }
        if (fluid.data() == null) {
            return FluidVariant.of((class_3611)fluid.fluid());
        }
        return FluidVariant.of((class_3611)fluid.fluid(), (class_2487)fluid.data());
    }
}

